/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.lang.Factory;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

public class ADSentenceSampleStream
implements ObjectStream<SentenceSample> {
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private int text = -1;
    private int para = -1;
    private boolean isSameText;
    private boolean isSamePara;
    private ADSentenceStream.Sentence sent;
    private boolean isIncludeTitles = true;
    private boolean isTitle;
    private final char[] ptEosCharacters;
    private Pattern meta1 = Pattern.compile("^(?:[a-zA-Z\\-]*(\\d+)).*?p=(\\d+).*");

    public ADSentenceSampleStream(ObjectStream<String> lineStream, boolean includeHeadlines) {
        this.adSentenceStream = new ADSentenceStream(lineStream);
        this.ptEosCharacters = Factory.ptEosCharacters;
        Arrays.sort(this.ptEosCharacters);
        this.isIncludeTitles = includeHeadlines;
    }

    public ADSentenceSampleStream(InputStreamFactory in, String charsetName, boolean includeHeadlines) throws IOException {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.ptEosCharacters = Factory.ptEosCharacters;
        Arrays.sort(this.ptEosCharacters);
        this.isIncludeTitles = includeHeadlines;
    }

    @Override
    public SentenceSample read() throws IOException {
        if (this.sent == null) {
            this.sent = this.adSentenceStream.read();
            this.updateMeta();
            if (this.sent == null) {
                return null;
            }
        }
        StringBuilder document = new StringBuilder();
        ArrayList<Span> sentences = new ArrayList<Span>();
        do {
            if ((!this.isTitle || this.isTitle && this.isIncludeTitles) && this.hasPunctuation(this.sent.getText())) {
                int start2 = document.length();
                document.append(this.sent.getText());
                sentences.add(new Span(start2, document.length()));
                document.append(" ");
            }
            this.sent = this.adSentenceStream.read();
            this.updateMeta();
        } while (this.isSamePara || this.isSameText);
        String doc = document.length() > 0 ? document.substring(0, document.length() - 1) : document.toString();
        return new SentenceSample(doc, sentences.toArray(new Span[sentences.size()]));
    }

    private boolean hasPunctuation(String text) {
        char lastChar;
        return (text = text.trim()).length() > 0 && Arrays.binarySearch(this.ptEosCharacters, lastChar = text.charAt(text.length() - 1)) >= 0;
    }

    private void updateMeta() {
        if (this.sent != null) {
            String meta = this.sent.getMetadata();
            Matcher m = this.meta1.matcher(meta);
            if (!m.matches()) {
                throw new RuntimeException("Invalid metadata: " + meta);
            }
            int currentText = Integer.parseInt(m.group(1));
            int currentPara = Integer.parseInt(m.group(2));
            this.isSameText = false;
            this.isSamePara = false;
            if (currentText == this.text) {
                this.isSameText = true;
            }
            if (this.isSameText && currentPara == this.para) {
                this.isSamePara = true;
            }
            this.isTitle = meta.contains("title");
            this.text = currentText;
            this.para = currentPara;
        } else {
            this.isSameText = false;
            this.isSamePara = false;
        }
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }
}

